﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Kanban.aspx.cs" MasterPageFile="~/OneColumn.master"   Inherits="GUI.Pages.Kanban" %>

<asp:Content ID="Content3" ContentPlaceHolderID="StylePlaceholder" runat="server">
    <link href="../repository/styles/kanban.css" rel="stylesheet" media="screen" />
    
 <style>
        .drag-container {
    /*box-sizing: border-box;
    border: 1px solid #cccccc;
    border-radius: 3px;
    width: 400px;
    padding: 8px;
    margin: 0 auto;*/
}
.drag-box {
    /*box-sizing: border-box;
    border: 1px solid rgba(0, 0, 0, 0.15);
    border-radius: 3px;
    padding: 4px 8px;
    margin: 4px;*/
    height:auto;
    cursor: pointer;
    /*background-color: #eeeeee;*/
}
.drag-box:hover {
    background-color: lightgray;
}

.drag-helper {
    box-sizing: border-box;
    position: absolute;
    display: none;
    top: auto;
    left: auto;
}
.drag-box-dragging .drag-box {
    background-color: lightgreen;
    opacity: 0.5;
    transform: scale(1.05);
}
        </style>
    
</asp:Content>

<asp:Content ID="Content1" ContentPlaceHolderID="Content" runat="server" >
    <!--KANBAN MAIN-->
       
    <div class="page-full-main-content">
        <div class="row">

            <div class="col-md-12 col-sm-12  kendo-kanban">
                
                <div class="portlet light bordered light-blue no-padding">
                    
                    <div class="portlet-title">
                        <div class="caption">
                            <span class="caption-subject bold font-dark uppercase" id="pageTitle" runat="server">
                                <asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_Kanban %>" />
                            </span>
                            <asp:HiddenField ID="hdnProjectId" runat="server" />
                            <asp:HiddenField ID="hdnUser" runat="server" />
                            <asp:HiddenField ID="hdnView" runat="server" />
                        </div>
                         <div class="form-actions text-right" style="padding:5px;">
                            <asp:Button OnClick="btnGantt_Click" runat="server" ID="btnKanban" CssClass="btn blue" CausesValidation="false" Text="<%$ Resources:ProjectManagementUI, UI_Gantt %>"/>
                            <asp:Button OnClick="btnActivity_Click" runat="server" ID="btnActivity" CssClass="btn blue" CausesValidation="false" Text="<%$ Resources:ProjectManagementUI, UI_Task2 %>"/>    
                         </div>

                        
                    </div>

                    <div class="portlet-body form no-padding full-percent">
                        <div id="kanbanBoardfull" class="kanban full-percent">
                            <!--BACKLOG-->
                            <div id="backlogcolumn" runat="server" dropzone="true" dragcont="0" columnid="0" class="drag-container col-md-3 backlog-wrapper">
                                <!--KANBAN TITLE-->
                                <div class="row kanban-caption">
                                    <div class="col-md-3 col-xs-6 caption">
                                        <H5 class="caption-subject bold">
                                           <asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_KanbanBacklog %>" />
                                        </H5>
                                    </div>
                                    <!--ADD NEW TASK-->
                                    <div class="col-md-9 col-xs-6 text-right">
                                        <a class="btn btn-sm btn-primary" onclick="openRadWindow(0,0)">
                                           <i class="fa fa-plus"></i> <asp:Literal ID="Literal3" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_NewActivity %>" />
                                        </a>
                                    </div>
                                    <!--END ADD NEW TASK-->
                                </div>
                                <!--END KANBAN TITLE-->
                                <!--##################################################################-->
                                <!--LISTA BACKLOG/REPEATER-->
                                <!--##################################################################-->
                                <!--OVDJE SE UPISUJU DIV kartice-->
                                <!--##################################################################--> 
                                <!--END LISTA-->
                                <!--##################################################################-->

                            </div>
                            <!--END BACKLOG-->

                             <!--END TASK-->
                             <div class="col-md-12 task-wrapp">
                                <!--KANBAN TITLE-->
                                <div class="row kanban-caption">
                                    <div class="col-md-3 col-xs-3 caption">
                                        <H5 class="caption-subject bold">
                                            <asp:Literal ID="Literal5" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_TaskBoard %>" /></H5>
                                    </div>

                                    <!--KANBAN SEARCH-->
                                   
                                    <!--END KANBAN SEARCH-->

                                     <!--FILTER TABLE-->
                                    <div class="col-md-9 col-xs-9 text-right">
                                     <div class="input-group">
                                            <asp:HiddenField ID="hdnsearchTekst" runat="server" /> 
                                            <asp:HiddenField ID="hdnAssigned" runat="server" value=""/> 
                                            <asp:HiddenField ID="hdnFinished" runat="server" value=""/> 
                                            <asp:HiddenField ID="hdnPrioritet" runat="server" value=""/> 
                                            <asp:HiddenField ID="hdnStartDatum" runat="server" value="" /> 
                                            <asp:HiddenField ID="hdnKrajDatum" runat="server" value=""/> 
                                            <asp:HiddenField ID="hdnFilter" runat="server" value=""/> 
                                            <asp:HiddenField ID="hdnLanguage" runat="server" value=""/> 
                                            <telerik:RadTextBox id="searchBoxKanban" runat="server" Skin="Bootstrap" CssClass="form-control" AutoPostBack="false" ClientEvents-OnValueChanged="PreventPostBack" ViewStateMode="Enabled" EnableViewState="true">
    
                                            </telerik:RadTextBox>      
                                            <span class="input-group-btn">
                                                    <asp:ImageButton  ID="PretragaKanban" class="btn btn-default" Height="34px" Width="34px" runat="server"  OnClick="PretragaKanban_Click"  ImageUrl="~/repository/img/icone-search-azul.png" style="padding:0px;0px;0px;0px;"></asp:ImageButton>
                                            </span>
                                                     <a href="#" class="dropdown dropdown-extended quick-sidebar-toggler btn btn-default" onclick="toggle_visibility('filterDiv');">
                                                        <span><i class="fa fa-filter"></i> <asp:Literal ID="Literal15" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_FilterTasks %>" />    </span>
                                                    </a>

                                                   <a href="#" class="dropdown dropdown-extended quick-sidebar-toggler btn btn-default" onclick="toggle_visibility('columnshideDiv');">
                                                        <i class="fa fa-columns"></i>
                                                    </a>

                                                    <a id="newColumn" runat="server" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#columneditID">
                                                       <i class="fa fa-plus"></i>  <asp:Literal ID="Literal16" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_NovaKolona %>" />
                                                    </a>
                                        </div>
                                    </div>
                                    <!--FILTER TABLE-->

                                </div>
                                <!--END KANBAN TITLE-->
   
                                <!--TASK ROW-->
                                <div id="kanbanboard" runat="server" class="row task-row">
                                   
                                    <!--##################################################################-->
                                    <!--RED REPEATER-->
                                    <!--##################################################################-->
                                    
                                        <!--##################################################################-->
                                        <!--KOLONA TASK REPEATER-->
                                        <!--##################################################################-->
                                        
                                        <!--##################################################################-->
                                        <!--END TASK KOLONA REPEATER -->
                                        <!--##################################################################-->


                                        <!--##################################################################-->
                                    <%--    <!--Dodaj novi task-->
                                           <!--End Dodaj novi task -->--%>
                                        <!--##################################################################-->


                                    </div>

                  
                                    <!--##################################################################-->
                                    <!--End RED REPEATER-->
                                    <!--##################################################################-->
     
                                </div>
                                <!--END TASK ROW-->
                             </div>
                            <!--END TASK-->
                        </div>
                    </div>
                </div>
            </div>
        </div>

    	<telerik:RadAjaxLoadingPanel runat="server" ID="RadAjaxLoadingPanel1"  >
        <div class="updatePanelProgress"><asp:Literal ID="Literal8" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_PleaseWait %>" />...</div>
    </telerik:RadAjaxLoadingPanel>
      <!--##################################################################-->
    <!-- FILTER COLUMN -->
    <!--##################################################################-->
  <%--  <div id="column-filder-ID" class="modal fade" role="dialog">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">

              <div class="filter-search">
                    <div class="filter-search-info">
                        <p class="filter-search-info-name">zeljka</p>
                        <p class="filter-search-info-number">2</p>
                    </div>
                    <div class="filter-search-form">
                        <i class="fa fa-search search-filter" aria-hidden="true"></i>
                        <input type="text" name="column-filter" placeholder="Search Cards">
                        <i class="fa fa-times-circle close-filter" aria-hidden="true"></i>
                    </div>
                </div>

            </div>
        </div>
    </div>--%>
    <!--##################################################################-->
    <!-- FILTER COLUMN -->
    <!--##################################################################-->
    
    <!--##################################################################-->
    <!-- EDIT ADD NEW -->
    <!--##################################################################-->
    <div id="columneditID" class="modal fade" role="dialog">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">

              <div class="edit-column">
                <div class="edit-column-properties">
                   
                    <input type="text" id="AddColumnName" name="edit-column-name" placeholder='<asp:Literal runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_NazivKolone%>" />' />
                    <label id="Nameerror" style="display:none;color:red;font-size:2em;">*</label>
                    <label class="edit-column-color" for="edit-column-colorpicker" style="padding-top:5px;">
                           <telerik:RadColorPicker Skin="Bootstrap" RenderMode="Lightweight" AutoPostBack="false"  runat="server"
                         ID="RadColorPicker1" Preset="None" ShowEmptyColor="False" ShowIcon="true" Width="250px">
                                                                             
                        </telerik:RadColorPicker> 
                    </label>
                    
                    </div>
                   <div class="edit-column-properties">
                
                   <input type="text" id="AddColumnDescription" name="edit-column-description" visible="false"  maxlength="20"/>
                          
                    </div>
 
                <div class="edit-column-options">
                    <a href="#" data-dismiss="modal" class="cancel-column-edit"><asp:Literal ID="Literal28" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_Cancel %>" /></a>
                    <button class="btn-primary"><asp:Literal ID="Literal26" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_Save %>" /></button>
                </div>
               </div>

            </div>
        </div>
    </div>
    <!--##################################################################-->
     <!-- END ADD NEW -->
    <!--##################################################################-->
        <!--##################################################################-->
    <!-- RENAME -->
    <!--##################################################################-->
    <div id="columnrenameID" class="modal fade" role="dialog">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
              <div class="move-card">
                    <div class="move-card-title">
                        <p><asp:Literal ID="Literal18" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_EditColumn %>" />    </p>
                        <i class="fa fa-times" aria-hidden="true"></i>
                    </div>
                    <div class="move-card-form">
                        <label for="select-board">
                        <p><asp:Literal ID="Literal19" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_Oldcolumnname %>" />     </p>
                            <input type="text" id="myvaluerename" name="select-board" readonly="readonly">              
                        </label>
                        <label for="select-board">
                        <p><asp:Literal ID="Literal20" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_ColumnId %>" />     </p>
                            <input type="text" id="myvaluerenameId" name="select-board" visible="true" readonly="readonly">              
                        </label>
                         <label for="select-board">
                        <p><asp:Literal ID="Literal23" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_NewColumnName %>" />     </p>
                            <input type="text" id="myvaluerenamenew" name="select-board" maxlength="20">              
                        </label>    
                       
                    </div>
                  <div class="edit-column-options">
                  <a href="#" data-dismiss="modal" class="cancel-column-edit"><asp:Literal ID="Literal29" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_Cancel %>" /></a>
                    <button class="btn-primary"><asp:Literal ID="Literal22" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_Rename %>" /></button>
                      </div>
                </div>

            </div>
        </div>
    </div>
    <!--##################################################################-->
    <!-- END RENAME -->
    <!--##################################################################-->
        <!--##################################################################-->
    <!-- RENAME -->
    <!--##################################################################-->
    <div id="columndeleteID" class="modal fade" role="dialog">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
              <div class="move-card">
                    <div class="move-card-title">
                        <p><asp:Literal ID="Literal21" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_DeleteNaslov %>" />    </p>
                        <i class="fa fa-times" aria-hidden="true"></i>
                    </div>
                    <div class="move-card-form">
                        <label for="select-board">
                        <p><asp:Literal ID="Literal24" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_NazivKolone %>" />     </p>
                            <input type="text" id="myvaluedelete" name="select-board" readonly="readonly">              
                        </label>
                        <label for="select-board">
                        <p><asp:Literal ID="Literal25" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_ColumnId %>" />     </p>
                            <input type="text" id="myvaluedeleteId" name="select-board" visible="true" readonly="readonly">              
                        </label>
                        <label id="Nemozebrisanje" style="display:none;color:red;font-size:1.5em;"><asp:Literal ID="Literal41" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_DeleteNotPosible %>" /></label>                      
                    </div>
                  <div class="edit-column-options">
                  <a href="#" data-dismiss="modal" class="cancel-column-edit"><asp:Literal ID="Literal30" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_Cancel %>" /></a>
                    <button class="btn-primary"><asp:Literal ID="Literal27" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_Delete %>" /></button>
                      </div>
                </div>

            </div>
        </div>
    </div>
    <!--##################################################################-->
    <!-- END RENAME -->
    <!--##################################################################-->

    <!--##################################################################-->
    <!-- SEARCH -->
    <!--##################################################################-->
   <%-- <div id="column-search-ID" class="modal fade" role="dialog">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">

              <div class="filter-search">
                    <div class="filter-search-info">
                        <p class="filter-search-info-name">zeljka</p>
                        <p class="filter-search-info-number">2</p>
                    </div>
                    <div class="filter-search-form">
                        <i class="fa fa-search search-filter" aria-hidden="true"></i>
                        <input type="text" name="column-filter" placeholder="Search Cards">
                        <i class="fa fa-times-circle close-filter" aria-hidden="true"></i>
                    </div>
                </div>

            </div>
        </div>
    </div>--%>
    <!--##################################################################-->
    <!-- END SEARCH -->
    <!--##################################################################-->


      
    <!--##################################################################-->
    <!-- MOVE -->
    <!--##################################################################-->
    <div id="columnmoveID" class="modal fade" role="dialog">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
              <div class="move-card">
                    <div class="move-card-title">
                        <p><asp:Literal ID="Literal12" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_MoveColumnNaslov %>" />    </p>
                        <i class="fa fa-times" aria-hidden="true"></i>
                    </div>
                    <div class="move-card-form">
                        <label for="select-board">
                        <p><asp:Literal ID="Literal10" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_MoveColumnColumn %>" />     </p>
                            <input type="text" id="myvalue" name="select-board" readonly="readonly">              
                        </label>
                            
                        <label for="select-list">
                            <p><asp:Literal ID="Literal11" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_MoveColumnPosition %>" />   </p>  
                            <input type="text" id="myposition" name="old-position" readonly="readonly">
                        </label>
                        
                        <label for="select-position">
    
                            <select name="select-position" id="SelectNewPosition" runat="server">

                            </select>
                            <p><asp:Literal ID="Literal14" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_MoveColumnNewPosition %>" /></p>
                        </label>

                    </div>
                  <div class="edit-column-options">
                  <a href="#" data-dismiss="modal" class="cancel-column-edit"><asp:Literal ID="Literal32" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_Cancel %>" /></a>
                    <button class="btn-primary"><asp:Literal ID="Literal13" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_Move %>" /></button>
                      </div>
                </div>

            </div>
        </div>
    </div>
    <!--##################################################################-->
    <!-- END MOVE -->
    <!--##################################################################-->

        <!--##################################################################-->
    <!-- MOVE CARD-->
    <!--##################################################################-->
    <div id="cardmoveID" class="modal fade" role="dialog">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
              <div class="move-card">
                    <div class="move-card-title">
                        <p><asp:Literal ID="Literal42" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_MoveCardNaslov %>" />    </p>
                        <i class="fa fa-times" aria-hidden="true"></i>
                    </div>
                    <div class="move-card-form">
                        <label for="select-board">
                        <p><asp:Literal ID="Literal43" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_MoveCardColumn %>" />     </p>
                            <input type="text" id="myvalueColumn" name="select-board" readonly="readonly">              
                        </label>
                       
                            <input type="hidden" id="mypositionActivity" name="select-board" >              
                        
                        <label for="select-newcolumn">
                            
                            <select name="select-newcolumn" id="selectNewColumnForCard" runat="server">
                                
                            </select>
                         <p><asp:Literal ID="Literal45" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_NewCardColumn %>" /></p>
                        </label>
    
<%--                        <label for="select-list">
                            <p><asp:Literal ID="Literal44" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_NewCardColumn %>" />   </p>  
                            <input type="text" id="mypositionColumn" name="old-position" readonly="readonly">
                        </label>--%
                        
                       <%-- <label for="select-position">
    
                            <select name="select-position" id="Select1" runat="server">

                            </select>
                            <p><asp:Literal ID="Literal45" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_MoveColumnNewPosition %>" /></p>
                        </label>--%>

                    </div>
                  <div class="edit-column-options">
                  <a href="#" data-dismiss="modal" class="cancel-column-edit"><asp:Literal ID="Literal46" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_Cancel %>" /></a>
                    <button class="btn-primary"><asp:Literal ID="Literal47" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_Move %>" /></button>
                      </div>
                </div>

            </div>
        </div>
    </div>
    <!--##################################################################-->
    <!-- END MOVE CARD-->
    <!--##################################################################-->

    <!-- END KANBAN MAIN-->


   
    <div class="row-light">
        <telerik:RadWindowManager Skin="Bootstrap"
            Behaviors="Close" ID="RadWindowManager1"
            Opacity="50" runat="server" >
            <Windows>
                <telerik:RadWindow ID="RadWindow1" Opacity="100" Width="90%" Height="650px" Title="<%$ Resources:ProjectManagementUI, Common_Activity %>" runat="server" CssClass="task-window" EnableViewState="false" OnClientClose="RefreshParentPage">
                </telerik:RadWindow>
            </Windows>
        </telerik:RadWindowManager>
    </div>
    
    <div id="filterDiv" class="page-quick-sidebar-wrapper task-filter-sidebar-wrapper" data-close-on-body-click="true" runat="server" style="z-index: 4900">
        <div class="page-quick-sidebar task-filter-sidebar">
            <div class="caption left">
                <h4><asp:Literal ID="Literal31" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_Filters %>" /></h4>
            </div>

            <button class="dropdown dropdown-extended quick-sidebar-toggler close"></button>

         <%--   <div class="search-task-name">
                <label>Filter by Task name</label>
                <div class="input-group">
                    <asp:TextBox runat="server" CssClass="form-control" ID="txtName" placeholder="Search by task name" />
                </div>
            </div>--%>
             <div class="search-assignee">
                <label><asp:Literal ID="Literal9" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_FilterByAssignee %>" /></label>
               <telerik:RadComboBox Skin="Bootstrap" Width="100%" runat="server" ID="selectAssigned" OnClientSelectedIndexChanged="getAssigned" AutoPostBack="false" EmptyMessage="<%$ Resources:ProjectManagementUI, Common_Choose %>" RenderingMode="Full" />
                
            </div>
                  <div class="search-status">
                <label><asp:Literal ID="Literal37" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_FilterByStatus %>" /></label>
                      <telerik:RadComboBox Skin="Bootstrap" Width="100%" runat="server" ID="ddlFinished" EmptyMessage="<%$ Resources:ProjectManagementUI, Common_Choose %>" OnClientSelectedIndexChanged="getFinished" AutoPostBack="false" RenderingMode="Full" >
                          <Items>
<telerik:RadComboBoxItem runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Choose%>" Value="" />
              <telerik:RadComboBoxItem runat="server" Text="Not Finished" Value="1" />
              <telerik:RadComboBoxItem runat="server" Text="Finished" Value="2" />
          </Items>
                      </telerik:RadComboBox>
                        <%--  <select name="Assignee" aria-controls="assignee" class="form-control">
                    <option>All</option>
                    <option>Not Finished</option>
                    <option>Finish</option>
                </select>--%>
            </div>
            <div class="search-priority">
                <label><asp:Literal ID="Literal39" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_FilterByPriority %>" /></label>
                <telerik:RadComboBox Skin="Bootstrap" Width="100%" runat="server" ID="ddlPriority" OnClientSelectedIndexChanged="getPriority" AutoPostBack="false" EmptyMessage="<%$ Resources:ProjectManagementUI, Common_Choose %>" RenderingMode="Full" />
            </div>

            <div class="search-start-date">
                <label><asp:Literal ID="Literal40" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_FilterByDate %>" /></label>
                <br/>
                <label class="control-label">
                    <asp:Literal ID="Literal7" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Begining %>" /></label>
                <telerik:RadDatePicker Skin="Bootstrap" Width="100%" runat="server" ID="txtFromDate">
                    <ClientEvents OnDateSelected="startdateSelected" />
                    <Calendar ID="Calendar1" runat="server">
                        <SpecialDays>
                            <telerik:RadCalendarDay Repeatable="Today" ItemStyle-BackColor="#999966">
                            </telerik:RadCalendarDay>
                        </SpecialDays>
                    </Calendar>
                </telerik:RadDatePicker>

                <label class="control-label">
                    <asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_End %>" /></label>
                <telerik:RadDatePicker Skin="Bootstrap"  Width="100%" runat="server" ID="txtToDate">
                    <ClientEvents OnDateSelected="enddateSelected" />
                    <Calendar ID="Calendar2" runat="server">
                        <SpecialDays>
                            <telerik:RadCalendarDay Repeatable="Today" ItemStyle-BackColor="#999966">
                            </telerik:RadCalendarDay>
                        </SpecialDays>
                    </Calendar>
                </telerik:RadDatePicker>

            </div>
             <button id="filterSearch" class="move-card-button" ><asp:Literal ID="Literal33" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_RefreshResults %>" /></button>
            
        </div>
    </div>

    <div id="columnshideDiv" class="page-quick-sidebar-wrapper task-filter-sidebar-wrapper" data-close-on-body-click="true" runat="server">
     <div id="columnshideDivpage" class="page-quick-sidebar task-filter-sidebar">
            <div id="columnshideDivcaption" class="caption left">
                <h4><asp:Literal ID="Literal34" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_ColumnHide %>" /></h4>
            </div>

            <button id="columnshideDivbutton" class="dropdown dropdown-extended quick-sidebar-toggler close"></button>

            <div id="columnshideDivDiv" runat="server">
            </div>
         <button class="move-card-button"><asp:Literal ID="Literal35" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_RefreshResults %>" /></button>
        </div>
    </div>
    <asp:HiddenField ID="columnsToAdd" runat="server" />
    <div id="addCard" class="modal" role="dialog" style="z-index:4900;">
        <div class="modal-dialog modal-sm">
            <div class="modal-content" enableviewstate="false">
              <div class="move-card">
                    <div class="move-card-title">
                        <p><asp:Literal ID="Literal17" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_AddTasksNaslov %>" />    </p>
                        <i class="fa fa-times" aria-hidden="true"></i>
                    </div>
                    <div class="add-card-form">                        
                        <label for="select-position">
                            <p><asp:Literal ID="Literal36" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_AddTasksNaslov %>" /></p>
                            <select id="selectActivity" class="form-control" runat="server" name="D1">
                                <option></option>
                            </select>
                         
                        </label>

                    </div>
                  <div class="edit-column-options">
                  <a href="#" data-dismiss="modal" class="cancel-column-edit" onclick="btnAddCardCancel_Click()"><asp:Literal ID="Literal38" runat="server" Text="<%$ Resources:ProjectManagementUI, Kanban_Cancel %>" /></a>
                  <a id="btnAddCard" runat="server" href="#" class="btn btn-primary" onclick="btnAddCard_Click()"><i class="fa fa-plus" style="padding-right:10px;"></i><asp:Literal ID="Literal6"  runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Add %>" /> </a>
                      </div>
                </div>
                
            </div>
        </div>
    </div>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="ScriptPlacerholder" runat="server">
    <script>

        function getAssigned(sender, eventArgs)
        {
            var dodjeljenser = document.getElementById("MainContentPlaceHolder_Content_hdnAssigned");
            dodjeljenser.setAttribute("value",eventArgs.get_item().get_value());
      
        }
        function getFinished(sender, eventArgs)
        {
            var dodjeljenser = document.getElementById("MainContentPlaceHolder_Content_hdnFinished");
            dodjeljenser.setAttribute("value",eventArgs.get_item().get_value());
           
        }
      function getPriority(sender, eventArgs)
        {
           var dodjeljenser = document.getElementById("MainContentPlaceHolder_Content_hdnPrioritet");
           dodjeljenser.setAttribute("value",eventArgs.get_item().get_value());
      }
      function startdateSelected(sender, eventArgs)
      {
          var dodjeljenser = document.getElementById("MainContentPlaceHolder_Content_hdnStartDatum");
          dodjeljenser.setAttribute("value", eventArgs.get_newValue());
      }
      function enddateSelected(sender, eventArgs)
      {
          var dodjeljenser = document.getElementById("MainContentPlaceHolder_Content_hdnKrajDatum");
          dodjeljenser.setAttribute("value", eventArgs.get_newValue());
      }
        function searchByFilter()
        {
            //alert(value);
            var dodjeljen = $('<%= selectAssigned.ClientID %>').value;
            var zavrsen=$('<%= ddlFinished.ClientID %>').value;
            var prioritet = $('<%= ddlPriority.ClientID %>').value;
            var datumStart = $('<%= txtFromDate.ClientID %>').value;
            var datumEnd = $('<%= txtToDate.ClientID %>').value;
            var dodjeljenser = $('<%= hdnAssigned.ClientID %>');
            var zavrsenser=$('<%= hdnFinished.ClientID %>');
            var prioritetser = $('<%= hdnPrioritet.ClientID %>');
            var datumStartser = $('<%= hdnStartDatum.ClientID %>');
            var datumEndser = $('<%= hdnKrajDatum.ClientID %>');
            var filterFull = $('<%= hdnFilter.ClientID %>');
            //dodjeljenser.value = dodjeljen;
            zavrsenser.value = zavrsen;
            datumStartser.value = prioritet;
            prioritetser.value = datumStart;
            datumEndser.value = datumEnd;
            var filter=dodjeljenser + ';' + zavrsenser + ';' + prioritetser + ';' + datumStartser + ';' + datumEndser;
            filterFull.value = filter;
            alert(filter);
            //console.log(dodjeljen + '- ' + zavrsen + '- ' + prioritet + '- ' + datumStart + '- ' + datumEnd);
        }

        function PreventPostBack(sender,eventArgs)
        {
            var searchtekst = $("#MainContentPlaceHolder_Content_hdnsearchTekst");
            if (eventArgs.get_newValue() != "" && eventArgs.get_oldValue() != "") {
                searchtekst.prop("value", eventArgs.get_newValue());
            }
            else if (eventArgs.get_newValue() != "" && eventArgs.get_oldValue() == "")
            {
                searchtekst.prop("value", eventArgs.get_newValue());
            }
            else if (eventArgs.get_newValue() == "" && eventArgs.get_oldValue() != "")
            {
                searchtekst.prop("value", eventArgs.get_newValue());
            }
            //var tekst = eventArgs.get_newValue();
           
            //alert('Session["searchvalue"] = "' + tekst + '";');
            eventArgs.set_cancel(true);
        }
  
        var modal = document.getElementById('addCard');
        var span = document.getElementById('buttonClose');
        function closeAddCard() {
            modal.style.display = "none";
           
        }
       
        function fnaddCard(id) {
            //alert(id);
            var view = document.getElementById('MainContentPlaceHolder_Content_hdnView');
            var viewYes=view.getAttribute('value');
            if (viewYes == "0")
            {
                return false;
            }
              var el = document.getElementById('<%= columnsToAdd.ClientID %>');
              el.setAttribute('value', id);
              
              //el.value = id;
              modal.style.display = "block";
              return false;
          }
          window.onclick = function (event) {

              if (event.target == modal) {
                  modal.style.display = "none";
              }
              return true;
          }
          function successAddCard(data) {
              modal.style.display = "none";
              RefreshParentPage();
          }
          function errorAddCard(data) {

          }
          function btnAddCard_Click(column) {
              var el = document.getElementById('<%= columnsToAdd.ClientID %>');
              var el1 = document.getElementById('<%= selectActivity.ClientID %>');
              //var columnId = el.getAttribute("columnid");
              var value = el1.value + ';' + el.value;
              //alert(value);
              //eventargs.set_cancel(true);
              callPageMethod(value);
              return false;
          }
          function btnAddCardCancel_Click() {
              $('#addCard').hide();

              return false;
          }
        function Search_Click(sender, args) {
        }
        function callPageMethod(value)
        {
            //alert('call page metod - ' + value);
            if (value != '' || value != null)
                //eventargs.set_cancel(true);
                //alert('call page metod');
            {
                PageMethods.AddCardToColumn(value, successAddCard, errorAddCard);
                return false;
            }
            else
            {
                 modal.style.display = "none";
              
            }
          }
         
          function toggle_visibility(id) {
              //alert(id);
            if (id == 'filterDiv')
            {
                
                var e = document.getElementById('MainContentPlaceHolder_Content_filterDiv');
                var e1 = document.getElementById('MainContentPlaceHolder_Content_columnshideDiv');
                //var e2 = document.getElementById('MainContentPlaceHolder_Content_columnsAddDiv');
                
                if (e.style.display == 'block')
                {

                    e.style.display = 'none';
                    e1.style.display = 'none';
                    //e2.style.display = 'none';
                    return false;
                    
                }
                else
                {

                    e.style.display = 'block';
                    e1.style.display = 'none';
                    //e2.style.display = 'none';
                    return false;
                    
                }

            } else if (id == 'columnshideDiv')
            {
                //alert('U if-u ' + id);
                var e = document.getElementById('MainContentPlaceHolder_Content_filterDiv');
                var e1 = document.getElementById('MainContentPlaceHolder_Content_columnshideDiv');
                //var e2 = document.getElementById('MainContentPlaceHolder_Content_columnsAddDiv');
                if (e1.style.display == 'block')
                {

                    e.style.display = 'none';
                    e1.style.display = 'none';
                    //e2.style.display = 'none';
                    return false;
                }
                else
                {

                    e.style.display = 'none';
                    e1.style.display = 'block';
                    return false;
                   // e2.style.display = 'none';
                }

            }
            
            
        }
        function successHide(data) {
            var str = data.Message.split(';');
            var kol = document.getElementById('MainContentPlaceHolder_Content_' + str[0]);

            if (str[1]==='hide')
            {
                kol.setAttribute("display","none");
            }
            else
            {
                kol.setAttribute("display", "block");
            }

        }
        function successDrag(data)
        {
            var str = data.Message.split(';');
            //console.log(data.Message);
            if (str[1] != ' ')
            {
                var kol = document.getElementById('MainContentPlaceHolder_Content_' + str[1] + "_captionspannumber");
                kol.innerHTML = str[2];
            }
            //change data on source column
            if (str[4] != ' ' )
            {
                var kolD = document.getElementById('MainContentPlaceHolder_Content_' + str[4]);
                var dragO = kolD.getAttribute("dragcont");
                var colid = kolD.getAttribute("columnid");
                var kolDspannum = document.getElementById('MainContentPlaceHolder_Content_' + str[4] + "_captionspannumber");
                kolDspannum.innerHTML = str[5];
                //Promjeni i columnid i dragobj na aktivnosti za dalji rad
                var kartica = document.getElementById('MainContentPlaceHolder_Content_' + str[6]);
                kartica.setAttribute("dragobj", dragO);
                kartica.setAttribute("columnid", colid);
            }

        }
        function errorHide() {
           
                }
        function updateBase(num1,num2,num3,stat) {
            var pr1=num1;
            var pr2=num2;
            var pr3=num3;
            var pr4 = stat;
            var activity = pr1 + '#' + pr2 + '#' + pr3 + '#' + pr4;
            PageMethods.HideColumns(activity, successHide, errorHide);
        }

        function openRadWindow(taskId,page) {

            var manager = GetRadWindowManager();
            if (page == 0) {
                var url = "../Pages/GanttActivity.aspx?ordnumb=" + taskId;
            }
            else if (page == 1)
            {
                var url = "../Pages/GanttActivityUpdates.aspx?aid=" + taskId;
            }
            else {
                var url = "../Pages/GanttActivityDocuments.aspx?aid=" + taskId;
            }
            var radwindow = manager.getWindowByName("RadWindow1");
            if (radwindow != null) {
                radwindow.setUrl(url);
                radwindow.show();

                if (radwindow.isVisible) {
                    //obtain the necessary values - percent and viewport size
                    var value = $telerik.$("#wndPercentageValue").attr("value");
                    var browserWidth = $telerik.$(window).width();
                    var browserHeight = $telerik.$(window).height();
                    //resize the RadWindow
                    radwindow.setSize(Math.ceil(browserWidth * value / 100), "650px");

                    //optionally you may also center the RadWindow
                    //otherwise it will stay where the original calculation for its top left corner leaves it
                    radwindow.center();
                }
               var expireTime = <%= FormsAuthentication.Timeout.TotalMinutes %>;
	            setTimeout(closeWin, expireTime*60*1000);
            }
            return false;
        }

        function RefreshParentPage() {
            
            location.reload();
        }
       
        var dragSrcCont = null;
        var dragDestEl = null;
        var dragEl = null;
        var dragElNode = null;
        var dragDestCont = null;
        var rootParent = null;
        var rootSibling = null;
        var indexdrag = 0;
        var color = null;
        var dragDestColumn = null;
        var activityid = null;
        var dragSrcContId = null;
        var dragDestColumnId = null;

        function addCard(elem) {
           
        }

        function handleDragStart(event,id) {
            var view = document.getElementById('MainContentPlaceHolder_Content_hdnView');
            var viewYes = view.getAttribute('value');
            //alert (viewYes);
            if (viewYes == "0"){
                return false;
            }
            var el = document.getElementById('MainContentPlaceHolder_Content_' + id);
            activityid = id;
            dragSrcCont = el.getAttribute("dragobj");
            dragSrcContId = el.getAttribute("columnid");
            dragEl = el.id;
            dragElNode = el;
            var xPos = parseInt(el.getAttribute('startLeft'), 10);
            var yPos = parseInt(el.getAttribute('startTop'), 10);
            //change object dimensions and class if comes from backlog
            if (dragSrcCont == '0')
            {
                dragElNode.setAttribute("class", "drag-box portlet light bordered activity");
            }

            event.dataTransfer.effectAllowed = 'move';
            event.dataTransfer.setData('text\html', event.target.id);
        }
      

        function handleDragOver(event,id) {
            if (event.preventDefault) {
                event.preventDefault(); // Necessary. Allows us to drop.
            }
            mousePos = mouseCoords(event);
            var dragHelper = document.querySelector('.drag-helper');

                var el = document.getElementById('MainContentPlaceHolder_Content_' + id);
                console.log(el.id);
                var dragObjCont = el.getAttribute("dragobj");
                var beforeNode = null; 
                dragDestCont = document.querySelectorAll("[dragcont='" + dragObjCont + "']");
                activeCont = dragDestCont[0];
                var childCards = activeCont.getElementsByClassName('drag-box');
                var j = 0;
                event.dataTransfer.dropEffect = 'move';  // See the section on the DataTransfer object.
               
                for (j = childCards.length - 1; j >= 0; j -= 1) {
                  
                    if (childCards[j] == el) {
                        beforeNode = el;//id
                        indexdrag = j;
                        activeCont.insertBefore(dragElNode, el);
                        rootParent = activeCont;
                        rootSibling = el;
                        dragDestColumn = activeCont.getAttribute("dragCont");
                        dragDestColumnId = el.getAttribute("columnid");
                       
                        // Make drag item visible
                        if (dragElNode.style.display !== '' && dragSrcCont!='0') {
                            dragElNode.style.display = '';
                            dragElNode.style.visibility = 'hidden';
                        }
                        else {
                            dragElNode.style.display = '';
                            dragElNode.style.visibility = 'visible';
                        }
                        return false;
                    }
                }
          
        }
       
        function mouseCoords(ev) {
            'use strict';

            if (ev.pageX || ev.pageY) {
                return {
                    x: ev.pageX,
                    y: ev.pageY
                };
            }

            return {
                x: ev.clientX + document.getElementById("kanbanBoardfull").scrollLeft - document.getElementById("kanbanBoardfull").clientLeft,
                y: ev.clientY + document.getElementById("kanbanBoardfull").scrollTop - document.getElementById("kanbanBoardfull").clientTop
            };
        }
        function handleDragEnter(event) {
        
        }

        function handleDragLeave(event) {
            
        }
        function getPosition(e) {
            'use strict';

            var left = 0,
                top = 0;
            //console.log('Pozicija za ' + e.id);
            while (e.offsetParent) {
                left += e.offsetLeft + (e.currentStyle ? (parseInt(e.currentStyle.borderLeftWidth, 10)).NaN0() : 0);
                top += e.offsetTop + (e.currentStyle ? (parseInt(e.currentStyle.borderTopWidth, 10)).NaN0() : 0);
                e = e.offsetParent;
            }

            left += e.offsetLeft + (e.currentStyle ? (parseInt(e.currentStyle.borderLeftWidth, 10)).NaN0() : 0);
            top += e.offsetTop + (e.currentStyle ? (parseInt(e.currentStyle.borderTopWidth, 10)).NaN0() : 0);

            return {
                x: left,
                y: top
            };
        }
        function handleDrop(event,el,user,id) {
           if (event.stopPropagation) {
                event.stopPropagation(); 
           }
           
           rootParent.insertBefore(dragElNode, rootSibling);
           var str = activityid + ';' + user + ';' + id + ';' + dragSrcCont + ';' + indexdrag + ";" + dragSrcContId + ";" + dragDestColumnId;
           //color = rootSibling.getAttribute("style");
           if (color == null)
           {
               color = 'border-top-color:' + rootSibling.getAttribute("colorid") + '!important;';
           }
           if (dragDestColumn != '0') {
               dragElNode.style.display = '';
               dragElNode.style.visibility = 'visible';
               dragElNode.setAttribute("class", "drag-box portlet light bordered");
               dragElNode.setAttribute("style", color);
               //console.log('Promjena boje - ' + color);

           }
           else
               {
                   dragElNode.setAttribute("class", "drag-box portlet light bordered light-gray task-wrapper task-backlog");
                   dragElNode.removeAttribute("style");
               }

           dragElNode = null;
           dragEl = null;
           
           //console.log(str);
           PageMethods.UpdateKanbanColumn(str,successDrag);
       
        }

        function handleDragEnd(event,id) {
           
          
           
        }
        function successAddColumn(data) {

            RefreshParentPage();
        }
        function errorAddColumn(data) {

        }
        function AddColumn(value) {
            //console.log('Hide add column');
            
                var projekat = document.getElementById('MainContentPlaceHolder_Content_hdnProjectId').getAttribute("value");
                var user = document.getElementById('MainContentPlaceHolder_Content_hdnUser').getAttribute("value");
                value = projekat + ";" + user + ";" + value;
                $('#columneditID').hide();//.modal('hide');
                PageMethods.AddColumn(value, successAddColumn, errorAddColumn);
           
        }
        function successMoveCards(data)
        {
            
            RefreshParentPage();
        }
        function errorMoveCards(data) {

        }
        function successReorderColumn(data)
        {
            
            RefreshParentPage();
        }
        function errorReorderColumn(data) {

        }
        function successRenameColumn(data) {

            RefreshParentPage();
        }
        function errorRenameColumn(data) {

        }
        function RenameColumn(value) {
            //console.log('Hide add column');

            var projekat = document.getElementById('MainContentPlaceHolder_Content_hdnProjectId').getAttribute("value");
            var user = document.getElementById('MainContentPlaceHolder_Content_hdnUser').getAttribute("value");
            value = projekat + ";" + user + ";" + value;
            $('#columnrenameID').hide();//.modal('hide');
            PageMethods.RenameColumn(value, successRenameColumn, errorRenameColumn);

        }
        function successDeleteColumn(data) {

            RefreshParentPage();
        }
        function errorDeleteColumn(data) {

        }
        function successCheck(data) {
            if (event.preventDefault) {
                event.preventDefault();
            }
            var greska = $('#Nemozebrisanje');
            //var literal = $('#Literal41');
            var poruka = data.Message.split(';');
            //alert(data.Message);
            if (poruka[0]=="0")
            {
                greska.html('');
                $('#Nemozebrisanje').css('display', 'none');
                var kolona = $('#myvaluedelete');
                var pozicija = $('#myvaluedeleteId');
                var kolname = kolona.val();
                var pozid = pozicija.val();
                var value = kolname + ";" + pozid;
                DeleteColumn(value);

            }
            else
            {
                greska.html(poruka[1]);
                $('#Nemozebrisanje').css('display', 'block');
            }
        }
        function errorCheck(data) {

        }
        function CheckAktivnost(value) {
            PageMethods.CheckColumn(value,successCheck,errorCheck);
        }
        function DeleteColumn(value) {
            //console.log('Hide add column');

            var projekat = document.getElementById('MainContentPlaceHolder_Content_hdnProjectId').getAttribute("value");
            var user = document.getElementById('MainContentPlaceHolder_Content_hdnUser').getAttribute("value");
            value = projekat + ";" + user + ";" + value;
            $('#columndeleteID').hide();//.modal('hide');
            PageMethods.DeleteColumn(value, successDeleteColumn, errorDeleteColumn);

        }
        function MoveColumn(value) {
            //console.log('Hide move column' + value);
            var projekat = document.getElementById('MainContentPlaceHolder_Content_hdnProjectId').getAttribute("value");
            var user = document.getElementById('MainContentPlaceHolder_Content_hdnUser').getAttribute("value");
            value = projekat + ";" + user + ";" + value;
            $('#columnmoveID').hide();//.modal('hide');
            PageMethods.ReorderColumns(value, successReorderColumn, errorReorderColumn);
           
            //return false;
        }
        function MoveCardToColumns(value) {
            //console.log('Hide move column' + value);
            var projekat = document.getElementById('MainContentPlaceHolder_Content_hdnProjectId').getAttribute("value");
            var user = document.getElementById('MainContentPlaceHolder_Content_hdnUser').getAttribute("value");
            value = projekat + ";" + user + ";" + value;
            //alert(value);
            $('#cardmoveID').hide();//.modal('hide');
            PageMethods.MoveCardsToColumns(value, successMoveCards, errorMoveCards);
           
            //return false;
        }
            jQuery(document).ready(function ($) {
                // Uzmi visinu screllbara iz elemnta ako je overflow
                var container_height = $('.kanban')[0].scrollHeight;


                // Setuj backlog i task board kontenjer da budu iste visine
                //$(".backlog-wrapper, .task-wrapp").height(container_height);

                var Kontejneri = document.querySelectorAll("[dragcont]");
                //get positions for all cards and containers
                //console.log('Run onload');
                //console.log(Kontejneri.length);
                var i = 0;
                for (i = 0; i < Kontejneri.length; i += 1) {
                    // Loop through each child element of each container
                    var j = 0;
                    //console.log('Prvi loop');
                    var childs = Kontejneri[i].getElementsByClassName('drag-box');
                    //console.log('Kontejner ' + i + ' - ' + childs.length + ' elemenata');
                    for (j = 0; j < childs.length; j += 1) {
                        elementInstance = childs[j];

                        //console.log(childs[j]);
                        pos = getPosition(childs[j]);
                        //console.log(pos);
                        // Save the width, height and position of each element
                        elementInstance.setAttribute('startWidth', parseInt(elementInstance.offsetWidth, 10));
                        elementInstance.setAttribute('startHeight', parseInt(elementInstance.offsetHeight, 10));
                        elementInstance.setAttribute('startLeft', pos.x);
                        elementInstance.setAttribute('startTop', pos.y);

                    }
                }
            });
            $(function () {
                $(document).on("click", "filterSearch", function (e) {
                    searchByFilter();

                });

            });
            $('#columneditID').on('hide.bs.modal', function (e) {
                // do something...
               // AddColumn();
            });
            $('#columndeleteID').on('hide.bs.modal', function (e) {
                // do something...
                // AddColumn();
                var greska = $('#Nemozebrisanje');
                greska.html('');
                //greska.val = null;
            });
            $('#columneditID').on('click', '.btn-primary', function (e) {
                if (event.preventDefault) {
                    event.preventDefault();
                }
                var kol = $('#AddColumnName');
                var greska = $('#Nameerror');
                var kolona = $('#AddColumnName').val();
                // var kolona = document.getElementById("myvalue");
                if (!kol.val()) {
                    //console.log('validacija uspjela');
                    // Add errors highlight
                    //greska.prop('visibility','visible');
                    //console.log('Validacija');
                    //console.log(greska.id);
                    $('#Nameerror').css('display', 'block');
                    // Stop submission of the form
                    
                }
                else {
                    // Remove the errors highlight
                    $('#Nameerror').css('display', 'none');
                    var pozicija = $('#AddColumnDescription').val();
                    //var pozicija = document.getElementById("myposition");
                    var colcolor = document.getElementById("ctl00_ctl00_MainContentPlaceHolder_Content_RadColorPicker1_ClientState");
                    //var e = $('#SelectNewPosition');
                    var boja = colcolor.getAttribute("value").split(':');
                    var hexboja = boja[1].replace(/"/g, '');
                    hexboja = hexboja.replace(/}/g, '');
                    var value = kolona + ";" + pozicija + ";" + hexboja;
                    //console.log(value);
                    //alert('Moving ' + value);
                    AddColumn(value);
                }
                //return false;
            });
            $('#columnrenameID').on('show.bs.modal', function (e) {
                var kolona = document.getElementById("myvaluerename");
                var pozicija = document.getElementById("myvaluerenameId");
                var button = e.relatedTarget;
                console.log(e.relatedTarget);
                kolona.setAttribute("value", button.getAttribute("data-myvaluerename"));
                pozicija.setAttribute("value", button.getAttribute("data-myvaluerenameId"));
            });

            $('#columnrenameID').on('click', '.btn-primary', function (e) {
                //alert('start');
                if (event.preventDefault) {
                    event.preventDefault();
                }
                var kolona = $('#myvaluerename');
                var pozicija = $('#myvaluerenameId');
                var kolonanew = $('#myvaluerenamenew');
                var kolname = kolona.val();
                var pozid = pozicija.val();
                //alert(kolona.val());
                if (!kolonanew.val()) {
                    alert("Enter new column name!");
                }
                else {
                    var value = kolname + ";" + pozid + ";" + kolonanew.val();
                    RenameColumn(value);
                }
                
            });

            $('#columndeleteID').on('show.bs.modal', function (e) {

                var kolona = document.getElementById("myvaluedelete");
                var pozicija = document.getElementById("myvaluedeleteId");
                var button = e.relatedTarget;
                //console.log(e.relatedTarget);
                kolona.setAttribute("value", button.getAttribute("data-myvaluedelete"));
                pozicija.setAttribute("value", button.getAttribute("data-myvaluedeleteId"));
            });

            $('#columndeleteID').on('click', '.btn-primary', function (e) {
                if (event.preventDefault) {
                    event.preventDefault();
                }
                var kolona = $('#myvaluedelete');
                var pozicija = $('#myvaluedeleteId');
                var kolname = kolona.val();
                var pozid = pozicija.val();
                var value = kolname + ";" + pozid;
                //Provjeri je li kolona ima aktivnosti
                var aktivnosti=CheckAktivnost(kolname);
                
            });
            $('#columnmoveID').on('show.bs.modal', function (e) {
                
                var kolona = document.getElementById("myvalue");
                var pozicija = document.getElementById("myposition");
                var button = e.relatedTarget;
                //console.log(e.relatedTarget);
                kolona.setAttribute("value", button.getAttribute("data-myvalue"));
                pozicija.setAttribute("value", button.getAttribute("data-myposition"));
            });
            $('#columnmoveID').on('click', '.btn-primary', function (e) {
                if (event.preventDefault) {
                    event.preventDefault();
                }
                //alert('Moving');
                var kolona = $('#myvalue').val();
                // var kolona = document.getElementById("myvalue");
                var pozicija = $('#myposition').val();
                //var pozicija = document.getElementById("myposition");
                var e = document.getElementById("MainContentPlaceHolder_Content_SelectNewPosition");
                //var e = $('#SelectNewPosition');
                var novapozicija=e.options[e.selectedIndex].value;
                var value = kolona + ";" + pozicija + ";" + novapozicija;
                //console.log(value);
                MoveColumn(value);
                //return false;
            });
            $('#columnmoveID').on('hide.bs.modal', function (e) {
                // do something...
               
            });
            $('#cardmoveID').on('show.bs.modal', function (e) {
                
                var kolona = document.getElementById("myvalueColumn");
                //var aktivnost = $('#mypositionActivity').val();
                //var el1 = document.getElementById('<%= selectNewColumnForCard.ClientID %>');
                var aktivnost = document.getElementById("mypositionActivity");
                var button = e.relatedTarget;
                //console.log(e.relatedTarget);
                kolona.setAttribute("value", button.getAttribute("data-myvalue"));
                aktivnost.setAttribute("value", button.getAttribute("data-myposition"));
            });
            $('#cardmoveID').on('click', '.btn-primary', function (e) {
                if (event.preventDefault) {
                    event.preventDefault();
                }
                
                var kolona = $('#myvalueColumn').val();
                // var kolona = document.getElementById("myvalue");
                var aktivnost = $('#mypositionActivity').val();
                //var pozicija = document.getElementById("myposition");
                var el1 = document.getElementById('<%= selectNewColumnForCard.ClientID %>');
                //var e = document.getElementById("MainContentPlaceHolder_Content_selectNewColumn");
                //var e = $('#SelectNewPosition');
                var novakolona=el1.options[el1.selectedIndex].value;
                //alert('Moving ' + novakolona); 
                var value = aktivnost + ";"  + kolona + ";"  + novakolona;
                //console.log(value);
                MoveCardToColumns(value);
                //return false;
            });
            function closeWin() {
                //GetRadWindow().BrowserWindow.location.href = 'Default2.aspx';
                GetRadWindow().close();
            }
            function GetRadWindow() {
                var oWindow = null;
                var manager = GetRadWindowManager();
                var radwindow = manager.getWindowByName("RadWindow1");
                if (radwindow != null) {
                    oWindow = radwindow;
                }
                return oWindow;
            }
    </script>
 
</asp:Content>
